<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Andrey Voytsehovsky <kess@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

class ElementJBCountdown extends Element
{

    const DATE_TYPE_PUBLISH_DOWN = 1;
    const DATE_TYPE_PICK         = 2;

    const TEMPLATE_NONE                = 0;
    const TEMPLATE_KEITHWOOD_TWO_LINES = 1;
    const TEMPLATE_KEITHWOOD_INLINE    = 2;
    const TEMPLATE_KEITHWOOD_ANIMATED  = 3;

    const EXPIRE_ACTION_HIDE            = 0;
    const EXPIRE_ACTION_UNPUBLISH       = 1;
    const EXPIRE_ACTION_CHANGE_CATEGORY = 2;

    protected $_elementPath;
    protected $_currentLang;

    /**
     * Constructor
     */
    function __construct()
    {
        parent::__construct();
        $this->_getFolder();
        $this->_initLanguage();
    }

    /**
     * Get the folder of the element
     */
    protected function _getFolder()
    {
        $dir = dirname(__FILE__);
        $this->app->path->register($dir, 'jbcountdown');
        $this->_elementPath = $this->app->path->path('jbcountdown:');
    }

    /**
     * Loads main language files
     */
    protected function _initLanguage()
    {
        $language = JFactory::getLanguage();
        $language->load('', $this->_elementPath);
        $this->_currentLang = $language->getTag();
    }

    /**
     * Disables element so it will no repeat its expire action
     */
    protected function disableElement()
    {
        $data = $this->data();
        $data['dateType'] = 0;
        $this->bindData($data);
        $this->app->table->item->save($this->getItem());
    }

    /**
     * Checks if the element has values
     * @param array $params
     * @return mixed
     */
    public function hasValue($params = array())
    {
        $dateType = $this->get('dateType', 0);

        return !empty($dateType);
    }

    /**
     * For editing in the admin panel
     * @return mixed
     */
    public function edit()
    {
        if ($layout = $this->getLayout('edit.php')) {
            return $this->renderLayout($layout);
        }

        return null;
    }

    /**
     * Renders element
     * @param array $params
     * @return string
     */
    public function render($params = array())
    {

        $params      = $this->app->data->create($params);
        $dateType    = (int)$this->get('dateType', 0);
        $format      = $params->get('format', 'dHMS');
        $introText   = $params->get('intro_text', '');
        $isPaused    = (int)$params->get('paused', 0);
        $template    = (int)$params->get('template', 0);
        $currentTime = strtotime($this->app->date->create('now'));

        if ($dateType == self::DATE_TYPE_PUBLISH_DOWN) {
            $item = $this->getItem();
            $date = strtotime($item->publish_down);
        } elseif ($dateType == self::DATE_TYPE_PICK) {
            $offset     = $this->app->date->getOffset();
            $date       = $this->app->date->create($this->get('datePick'), $offset);
            $offsetTime = $date->getOffsetFromGMT();
            $date       = strtotime($date) - $offsetTime;
        } else {
            return null;
        }

        if ($date < $currentTime) {
            $this->disableElement();
            $expireAction = $this->config->get('expire_action', 0);            

            if ($expireAction == self::EXPIRE_ACTION_HIDE) {                
                return null;
            } elseif ($expireAction == self::EXPIRE_ACTION_UNPUBLISH) {
                $item = $this->getItem();
                $item->setState(0, true);

                return null;
            } elseif ($expireAction == self::EXPIRE_ACTION_CHANGE_CATEGORY) {
                $newCategory  = $this->get('newCategory', 0);

                if ($newCategory) {
                    $item         = $this->getItem();
                    $categories   = array();
                    $categories[] = $newCategory;
                    $item->getElement('_itemcategory')->bindData(array(
                        'primary' => $newCategory,
                        'value'   => $categories
                    ));
                    $this->app->table->item->save($item);
                    $this->app->category->saveCategoryItemRelations($item, $categories);
                }

                return null;
            }
        }

        // render layout

        if ($template == self::TEMPLATE_NONE) {
            return null;
        } elseif ($template == self::TEMPLATE_KEITHWOOD_TWO_LINES) {
            $template = 'keithwoodtwolines.php';
        } elseif ($template == self::TEMPLATE_KEITHWOOD_INLINE) {
            $template = 'keithwoodinline.php';
        } elseif ($template == self::TEMPLATE_KEITHWOOD_ANIMATED) {
            $template = 'keithwoodanimated.php';
        }

        $timespan = $date - $currentTime;

        if ($layout = $this->getLayout($template)) {
            return $this->renderLayout($layout, array(
                'timespan'  => $timespan,
                'lang'      => $this->_currentLang,
                'format'    => $format,
                'introText' => $introText,
                'isPaused'  => $isPaused
            ));
        }

        return null;
    }


}

