<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Andrey Voytsehovsky <kess@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');
$this->app->jbassets->js('elements:jbcountdown/plugins/keithwood/jquery.countdown.min.js');

$supportedLangs = array('ru-RU', 'uk-UA');
if (in_array($lang, $supportedLangs)) {
    $this->app->jbassets->js('elements:jbcountdown/plugins/keithwood/jquery.countdown-' . $lang . '.js');
}

$id        = uniqid('jbzoo-countdown-');
$toLayout  = str_split(strtolower($format));
$jsLayout  = '';
$arrLength = count($toLayout);
$i         = 0;
$separator = ', ';

foreach ($toLayout as $part) {
    //if it's the last part of the layout, using dot instead of comma
    if(++$i === $arrLength) {
        $separator = '.';
    }

    $jsLayout .= '{' . $part . '<}'
        .     '<span class="' . $part . ' part">'
        .         '<span class="digits">'
        .             '{' . $part . 'n} '
        .         '</span>'
        .         '<span class="text">'
        .             '{' . $part . 'l}' . $separator
        .         '</span>'
        .     '</span>'
        . '{' . $part . '>}';
}
?>

<div class="jbcountdown keithwood inline" id="<?php echo $id; ?>">
    <?php
    if ($introText) {
        echo '<div class="intro">' . $introText . '</div>';
    }
    ?>
    <div class="counter"></div>
</div>

<script>
    jQuery(document).ready(function(){
        jQuery('#<?php echo $id; ?> .counter').countdown({
            until : <?php echo $timespan; ?>,
            format: '<?php echo $format; ?>',
            layout: '<?php echo $jsLayout; ?>'
        });
        <?php
            if ($isPaused) {
                echo 'jQuery("#' . $id . ' .counter").countdown("pause")';
            }
        ?>
    });
</script>