<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Andrey Voytsehovsky <kess@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

?>

<div>
    <div class="row">
        <p>
            <?php echo JText::_('JBZOO_JBCOUNTDOWN_DATE_TYPE'); ?>
        </p>
    <?php
        //input is used to choose date type
        $dateTypeOptions = array();
        $dateTypeOptions[] = JText::_('JBZOO_JBCOUNTDOWN_DATE_NONE');
        $dateTypeOptions[] = JText::_('JBZOO_JBCOUNTDOWN_DATE_PUBLISH_DOWN');
        $dateTypeOptions[] = JText::_('JBZOO_JBCOUNTDOWN_DATE_PICK');
        echo $this->app->jbhtml->select(
            $dateTypeOptions,
            $this->getControlName('dateType'),
            '',
            $this->get('dateType')
        );
    ?>
    </div>


    <div class="row">
    <?php
        //input is used to select specific date
        echo JText::_('JBZOO_JBCOUNTDOWN_PICK_DATE');
        $name = $this->getControlName('datePick');
        echo $this->app->html->_(
            'zoo.calendar',
            $this->get('datePick'),
            $name,
            $name,
            array('class' => 'calendar-element'),
            true
        );

    ?>
    </div>


    <?php if ($this->config->get('expire_action', 0) == ElementJBCountdown::EXPIRE_ACTION_CHANGE_CATEGORY) { ?>
        <div class="row">
            <p>
                <?php echo JText::_('JBZOO_JBCOUNTDOWN_CHOOSE_NEW_CATEGORY'); ?>
            </p>
            <?php
            //input is used to select a new category
            $options = array();
            $options[] = $this->app->html->_('select.option', '-1', '- ' . JText::_('Select Category') . ' -');
            $options[] = $this->app->html->_('select.option', '', '- ' . JText::_('uncategorized') . ' -');
            $options[] = $this->app->html->_('select.option', '0', '- '.JText::_('Frontpage'));
            echo $this->app->html->_('zoo.categorylist', $this->app->zoo->getApplication(), $options, $this->getControlName('newCategory'), 'class="inputbox"', 'value', 'text', $this->get('newCategory'));
            ?>
        </div>
    <?php } ?>
</div>

<script>
    var dateTypeSelect = jQuery('select[name="<?php echo $this->getControlName('dateType'); ?>"]');

    function checkDateTypeSelect()
    {
        if (jQuery(dateTypeSelect).val() == 2) {
            jQuery(dateTypeSelect).parent().next().show();
        }
        else {
            jQuery(dateTypeSelect).parent().next().hide();
        }
    }

    jQuery(document).ready(function() {
        checkDateTypeSelect();
    });

    jQuery(dateTypeSelect).change(function() {
        checkDateTypeSelect();
    });
</script>