<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Andrey Voytsehovsky <kess@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');
$this->app->jbassets->css('elements:jbcountdown/plugins/keithwood/jquery.countdown.css');
$this->app->jbassets->js('elements:jbcountdown/plugins/keithwood/jquery.countdown.min.js');

$supportedLangs = array('ru-RU', 'uk-UA');
if (in_array($lang, $supportedLangs)) {
    $this->app->jbassets->js('elements:jbcountdown/plugins/keithwood/jquery.countdown-' . $lang . '.js');
}

$id       = uniqid('jbzoo-countdown-');
$toLayout = str_split(strtolower($format));
$jsLayout = '';

foreach ($toLayout as $part) {
    $jsLayout .= '{' . $part . '<}'
               .     '<div class="' . $part . ' block">'
               .         '<div class="digits clearfix">'
               .             '<span class="digit image{' . $part . '10}"></span>'
               .             '<span class="digit image{' . $part . '1}"></span>'
               .         '</div>'
               .         '<div class="text">'
               .             '{' . $part . 'l}'
               .         '</div>'
               .     '</div>'
               . '{' . $part . '>}';
}
?>

<div class="jbcountdown keithwood animated" id="<?php echo $id; ?>">
    <?php
        if ($introText) {
            echo '<div class="intro">' . $introText . '</div>';
        }
    ?>
    <div class="counter clearfix"></div>
</div>

<script>
    jQuery(document).ready(function(){
        var digitsCheck = [];
        var digits = [];
        var start = 0;
        jQuery('#<?php echo $id; ?> .counter').countdown({
            until : <?php echo $timespan; ?>,
            format: '<?php echo $format; ?>',
            layout: '<?php echo $jsLayout; ?>',
            onTick: function() {
                if (start == 0) {
                    jQuery('#<?php echo $id; ?> .digit').each(function (i) {
                        digitsCheck[i] = jQuery(this);
                        start = 1;
                    });
                }
                else {
                    jQuery('#<?php echo $id; ?> .digit').each(function (i) {
                        digits[i] = jQuery(this);
                        digits[i].removeClass('moving');
                        digitsCheck[i].removeClass('moving');
                        if (digits[i].attr('class') != digitsCheck[i].attr('class')) {
                            digitsCheck[i] = digits[i];
                            jQuery(this).addClass('moving');
                        }
                    });
                }
            }
        });
        <?php
            if ($isPaused) {
                echo 'jQuery("#' . $id . ' .counter").countdown("pause")';
            }
        ?>
    });
</script>