<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @coder       Kalistratov Sergey <kalistratov.s.m@gmail.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

class ElementJBChronoForms extends Element
{

    /**
     * @param array $params
     * @return bool|void
     */
    public function hasValue($params = array())
    {
        if ($this->get('value')) {
            return true;
        }

        return false;
    }

    /**
     * Render action
     * @param array $params
     * @return string|void
     */
    public function render($params = array())
    {
        $formName = $this->get('value');
        return $this->_displayForm($formName);
    }

    /**
     * Edit action
     * @return mixed
     */
    public function edit()
    {
        return $this->app->html->_('control.text', $this->getControlName('value'), $this->get('value', $this->config->get('default')), 'size="60" maxlength="255"');
    }

    /**
     * @param $formName
     * @return null|string
     */
    private function _displayForm($formName)
    {
        //load chronoforms classes
        if (file_exists(JPATH_SITE . DS . 'components' . DS . 'com_chronoforms' . DS . 'chronoforms.html.php') &&
            file_exists(JPATH_SITE . DS . 'components' . DS . 'com_chronoforms' . DS . 'libraries' . DS . 'chronoform.php')
        ) {
            if (!empty($formName)) {
                require_once(JPATH_SITE . DS . 'components' . DS . 'com_chronoforms' . DS . 'chronoforms.html.php');
                require_once(JPATH_SITE . DS . 'components' . DS . 'com_chronoforms' . DS . 'libraries' . DS . 'chronoform.php');

                $form = CFChronoForm::getInstance($formName, true);

                if (empty($form->form_name)) {
                    return "There is no form with this name or may be the form is unpublished, Please check the form and the url and the form management.";
                }

                $loaded_form = JRequest::getVar('chronoform');

                if (!empty($loaded_form) && (trim($loaded_form) != $form->form_name)) {
                    $event = '';
                } else {
                    $event = JRequest::getVar('event');
                }

                if (empty($event)) {
                    $event = 'load';
                }

                $form->process($event);
                ob_start();
                HTML_ChronoForms::processView($form);
                $output = ob_get_clean();

                return $output;
            }

            return 'Form empty';
        }

        return null;
    }

}

if (!class_exists('JCFParameter')) {

    /**
     * Class JCFParameter
     */
    class JCFParameter
    {

        /**
         * Params
         * @var array|null
         */
        var $params = null;

        /**
         * Constructor
         * @param string $string
         */
        function __construct($string = '')
        {
            if (is_array($string)) {
                $this->params = $string;
            } else {
                $this->setParams($string);
            }
        }

        /**
         * Get params
         * @param $k
         * @param null $v
         * @return null
         */
        function get($k, $v = null)
        {
            if (array_key_exists($k, $this->params)) {
                return $this->params[$k];
            } else {
                return $v;
            }
        }

        /**
         * @param $k
         * @param $v
         */
        function set($k, $v)
        {
            $this->params[$k] = $v;
        }

        /**
         * Set params
         * @param string $string
         */
        function setParams($string = '')
        {
            if (strlen(trim(($string))) > 0) {
                $data = json_decode($string, true);
                $this->params = $data;
            } else {
                $this->params = array();
            }
        }

        /**
         * @return mixed|string
         */
        function toString()
        {
            return json_encode($this->params);
        }

        /**
         * @return array|null
         */
        function toArray()
        {
            return $this->params;
        }

        /**
         * @return mixed
         */
        function toObject()
        {
            return json_decode(json_encode($this->params));
        }
    }

}