<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @coder       Kalistratov Sergey <kalistratov.s.m@gmail.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * Class ElementJBChronoForms
 */
class ElementJBChronoForms extends Element
{

    /**
     * Element name
     * @var string
     */
    public $elementName = 'jbchronoforms';

    /**
     * Element path to folder
     * @var null
     */
    private $_elementPath = null;

    /**
     * Element Constructor
     */
    public function __construct()
    {
        parent::__construct();

        $this->_registerElementPath();
        $this->_initLanguage();
    }

    /**
     * Get parameter form object to render input form.
     * @return mixed
     */
    public function getConfigForm() {
        $path = $this->_elementPath . 'fields';
        return parent::getConfigForm()->addElementPath($path);
    }

    /**
     * Has value
     * @param array $params
     * @return bool|void
     */
    public function hasValue($params = array())
    {
        if ($this->get('value')) {
            return true;
        }

        return false;
    }

    /**
     * Render action
     * @param array $params
     * @return string|void
     */
    public function render($params = array())
    {
        $formName = $this->get('value');
        return $this->_displayForm($formName);
    }

    /**
     * Edit action
     * @return mixed
     */
    public function edit()
    {
        $chronoFormList = $this->getChromoFormList();
        $defaultValue   = $this->config->get('form_name', 'default');

        return $this->app->jbhtml->select($chronoFormList, $this->getControlName('value'), null, $this->get('value', $defaultValue));
    }

    /**
     * Get ChromoForms form list
     * @return array
     */
    public function getChromoFormList()
    {
        $formsList = array('default' => JText::_('JBZOO_CHRONOFORMS_SELECT_FORM'));

        if (file_exists(JPATH_SITE . DS . 'components' . DS . 'com_chronoforms' . DS . 'chronoforms.html.php') &&
            file_exists(JPATH_SITE . DS . 'components' . DS . 'com_chronoforms' . DS . 'libraries' . DS . 'chronoform.php')
        ) {
            $database = JFactory::getDBO();
            $query    = "SELECT name FROM #__chronoforms WHERE published = 1";

            $database->setQuery($query);

            $queryListForms = $database->loadAssocList();

            if (!empty($queryListForms)) {
                foreach($queryListForms as $form) {
                    $formsList[$form['name']] = $form['name'];
                }
            }
        }

        return $formsList;
    }

    /**
     * Init language
     * @return void
     */
    protected function _initLanguage()
    {
        $language = JFactory::getLanguage();
        $language->load('', $this->_elementPath);
    }

    /**
     * Register element path to folder
     * @return void
     */
    protected function _registerElementPath()
    {
        $dir = dirname(__FILE__);
        $this->app->path->register($dir, $this->elementName);
        $this->_elementPath = $this->app->path->path($this->elementName . ':');
    }

    /**
     * Display chronoforms
     * @param $formName
     * @return null|string
     */
    private function _displayForm($formName)
    {
        //load chronoforms classes
        if (file_exists(JPATH_SITE . DS . 'components' . DS . 'com_chronoforms' . DS . 'chronoforms.html.php') &&
            file_exists(JPATH_SITE . DS . 'components' . DS . 'com_chronoforms' . DS . 'libraries' . DS . 'chronoform.php')
        ) {
            if (!empty($formName)) {
                require_once(JPATH_SITE . DS . 'components' . DS . 'com_chronoforms' . DS . 'chronoforms.html.php');
                require_once(JPATH_SITE . DS . 'components' . DS . 'com_chronoforms' . DS . 'libraries' . DS . 'chronoform.php');

                $form = CFChronoForm::getInstance($formName, true);

                if (empty($form->form_name)) {
                    return JText::_('JBZOO_CHRONOFORMS_ERROR_NO_FORM');
                }

                $loaded_form = JRequest::getVar('chronoform');

                if (!empty($loaded_form) && (trim($loaded_form) != $form->form_name)) {
                    $event = '';
                } else {
                    $event = JRequest::getVar('event');
                }

                if (empty($event)) {
                    $event = 'load';
                }

                $form->process($event);
                ob_start();

                HTML_ChronoForms::processView($form);
                $output = ob_get_clean();

                return $output;
            }

            return JHtml::_('JBZOO_CHRONOFORMS_FORM_EMPTY');
        }

        return null;
    }

}

if (!class_exists('JCFParameter')) {

    /**
     * Class JCFParameter
     */
    class JCFParameter
    {

        /**
         * Params
         * @var array|null
         */
        var $params = null;

        /**
         * Constructor
         * @param string $string
         */
        function __construct($string = '')
        {
            if (is_array($string)) {
                $this->params = $string;
            } else {
                $this->setParams($string);
            }
        }

        /**
         * Get params
         * @param $k
         * @param null $v
         * @return null
         */
        function get($k, $v = null)
        {
            if (array_key_exists($k, $this->params)) {
                return $this->params[$k];
            } else {
                return $v;
            }
        }

        /**
         * @param $k
         * @param $v
         */
        function set($k, $v)
        {
            $this->params[$k] = $v;
        }

        /**
         * Set params
         * @param string $string
         */
        function setParams($string = '')
        {
            if (strlen(trim(($string))) > 0) {
                $data = json_decode($string, true);
                $this->params = $data;
            } else {
                $this->params = array();
            }
        }

        /**
         * @return mixed|string
         */
        function toString()
        {
            return json_encode($this->params);
        }

        /**
         * @return array|null
         */
        function toArray()
        {
            return $this->params;
        }

        /**
         * @return mixed
         */
        function toObject()
        {
            return json_decode(json_encode($this->params));
        }
    }

}