<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @copyright   Copyright (C) JBZoo.com,  All rights reserved.
 * @license     http://jbzoo.com/license-pro.php JBZoo Licence
 * @coder       Andrey Voytsehovsky <kess@jbzoo.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

// register ElementRepeatable class
App::getInstance('zoo')->loader->register('ElementRepeatable', 'elements:repeatable/repeatable.php');


class ElementJBHyphenText extends ElementRepeatable implements iRepeatSubmittable {

    const CACHING_DISABLED = 0;
    const CACHING_ENABLED  = 1;
    const CACHING_ENFORCED = 2;

    protected $_elementPath;
    protected $_isHyphenation;
    protected $_caching;

    /**
     * Constructor
     */
    function __construct()
    {
        parent::__construct();
        $this->_getFolder();
        $this->_initLanguage();
    }


    /**
     * Checks if the element has values
     * @param array $params
     * @return bool
     */
    protected function _hasValue($params = array()) {
        $value = $this->get('value', $this->config->get('default'));
        return !empty($value) || $value === '0';
    }


    /**
     * Adds search data
     * @return string
     */
    protected function _getSearchData() {
        return $this->get('value', $this->config->get('default'));
    }


    /**
     * Get the folder of the element
     */
    protected function _getFolder()
    {
        $dir = dirname(__FILE__);
        $this->app->path->register($dir, 'jbhyphentext');
        $this->_elementPath = $this->app->path->path('jbhyphentext:');
    }


    /**
     * For editing in the admin panel
     * @return mixed
     */
    protected function _edit() {
        return $this->app->html->_(
            'control.text',
            $this->getControlName('value'),
            $this->get('value', $this->config->get('default')),
            'size="60" maxlength="255"'
        );
    }


    /**
     * Initializes hyphenation plugin
     */
    protected function _initHyphenation() {
        $this->app->loader->register('phpHypher', 'jbhyphentext:hypher/hypher.php');
        $this->hyphenator = new phpHypher($this->_elementPath . '/hypher/hyph_ru_RU.conf');
        $this->hyphenator->set_limits(
            (int)$this->config->get('left_limit', 2),
            (int)$this->config->get('right_limit', 2),
            (int)$this->config->get('length_limit', 4),
            (int)$this->config->get('right_limit_last', 2),
            (int)$this->config->get('left_limit_uc', 2)
        );
    }


    /**
     * For the front-end submit
     * @param array $params
     * @return mixed|void
     */
    public function _renderSubmission($params = array()) {
        return $this->_edit();
    }


    /**
     * Loads main language files
     */
    protected function _initLanguage()
    {
        $language = JFactory::getLanguage();
        $language->load('', $this->_elementPath);
    }


    /**
     * Renders the element
     * @param array $params
     * @return string
     */
    public function render($params = array()) {

        $params         = $this->app->data->create($params);
        $this->_caching = (int)$this->config->get('caching', 0);
        $result         = array();

        if ($this->_isHyphenation = (int)$this->config->get('enable_hyphenation', 1)) {
            $this->_initHyphenation();
        }

        foreach ($this as $self) {
            $result[] = $this->_render($params);
        }

        return $this->app->element->applySeparators($params->get('separated_by'), $result);
    }


    /**
     * Renders the element
     * @param array $params
     * @return string
     */
    protected function _render($params = array()) {
        $value = $this->get('value', $this->config->get('default'));

        if ($this->_isHyphenation) {

            if ($this->_caching == self::CACHING_ENABLED || $this->_caching == self::CACHING_ENFORCED) {
                $group = 'jbhyphentext_cache';
                $cacheFlag = false;
                if ($this->_caching == self::CACHING_ENFORCED) {
                    $cacheFlag = true;
                }

                if (!($cachedValue = $this->app->jbcache->get($value, $group, $cacheFlag))) {
                    $cachedValue = $this->hyphenator->hyphenate($value, 'UTF-8');
                    $this->app->jbcache->set($value, $cachedValue, $group, $cacheFlag);
                }

                return $cachedValue;
            } else {
                $value = $this->hyphenator->hyphenate($value, 'UTF-8');

                return $value;
            }
        }

        return $value;
    }
}