Название:	phpHypher

Версия:		0.1.0

Дата:		29.05.2010

Статус:		beta

Автор:		Сергей Куракин <sergeykurakin@gmail.com>

Лицензия:	LGPL v.3

URL:		http://quittance.ru/hyphenator.php

Описание:	Класс php5 для расстановки мягких переносов по алгоритму
		Ляна-Кнута.  Включает  свободно  распространяемый  набор
		правил переносов для русского языка.


========================================================================
Quickstart
========================================================================

<?php
 
// Подключение библиотеки.
require_once 'libs/hypher.php';
 
// Создание объекта, загрузка файла описания и набора правил.
$hy_ru = new phpHypher('libs/hyph_ru_RU.conf');
 
// Расстановка переносов.
echo $hy_ru->hyphenate('Текст, в котором надо расставить переносы', 'UTF-8');
 
echo $hy_ru->hyphenate('Текст для расстановки переносов', 'UTF-8');
 
echo $hy_ru->hyphenate('...и так далее...', 'UTF-8');
 
?>

В этом примере  предполагается,  что все файлы библиотеки,  включая файл
описания языка и наборы правил,  находятся в директории libs/. Кодировка
текста для расстановки  переносов  может быть utf-8 или любая восьмибит-
ная; указывается вторым параметром метода hyphenate().


========================================================================
Особенности и преимущества phpHypher
========================================================================

	Конфигурационный файл описания языка

Многочисленные  параметры  расстановки переносов для каждого конкретного
языка задаются директивами в файле описания языка, имя которого является
обязательным параметром при создании экземпляра объекта phpHypher.


	Кеширование обработанных словарей со встроенным механизмом
	проверки их актуальности

В процессе создания экземпляра  объекта phpHypher  происходит загрузка и
обработка  наборов правил (паттернов)  и других данных,  необходимых для
расстановки  переносов.  Процесс обработки и оптимизации данных занимает
доли секунды,  но эти доли секунды могут оказаться критичными для произ-
водительности нагруженной системы.  Поэтому обработанные данные сохраня-
ются для дальнейшего использования в файл,  имя которого задано директи-
вой compiled.

В дальнейшем  обработанные  и оптимизированные словари будут загружаться
непосредственно  из compiled-файла с обязательным контролем его актуаль-
ности.  В случае потери актуальности (или отсутствия), compiled-файл бу-
дет автоматически  обновлен (или создан заново)  из исходных файлов пра-
вил.

Таким образом,  время загрузки словарей и других необходимых для расста-
новки переносов данных сведено к минимуму.  С другой стороны,  phpHypher
позволяет  оперативно  вносить изменения в файл описания языка и в файлы
правил  переносов -- изменения  будут учтены  при первом  же вызове кон-
структора класса.


	Расширенные настройки условий переноса слов

Обычно  системы расстановки  переносов  в тексте позволяют  задавать три
стандартных условия переносов:  ограничение слева -- минимальное количе-
ство символов,  которое допустимо отделять от слова спереди; ограничение
справа -- минимальное количество букв,  которое можно переносить на дру-
гую строку; ограничение по длине -- минимальная длина слова, допускающая
переносы.

Помимо стандартных,  phpHypher предоставляет возможность отдельно задать
еще два дополнительных условия: ограничение слева для слов, начинающихся
с заглавной буквы и ограничение справа для последнего слова абзаца. Рас-
ширенные условия переноса слов позволяют  более тонко настроить  систему
автоматической расстановки мягких переносов в особых случаях для различ-
ных способов выключки текста.


	Запрет переноса слов

Переносы не будут расставлены в словах, экранированных при помощи обрат-
ной  косой черты "\" (код символа 0x5C),  которая  должна  располагаться
непосредственно перед первой буквой экранируемого слова.

Например,  для расстановки переносов в англоязычном тексте, включающем в
себя теги разметки, необходимо экранировать теги, чтобы избежать расста-
новки переносов  внутри них.  Но такой необходимости нет при расстановке
переносов на русском языке, поскольку русскоязычный текст не пересекает-
ся по алфавиту с тегами, записанными латинскими буквами.


	Возможность одновременного использования нескольких наборов
	правил переносов

Конфигурационный  файл описания языка позволяет  подключать одновременно
несколько  наборов правил,  что придает системе дополнительную гибкость.
Можно иметь один основной набор правил,  а исправления и дополнения вно-
сить в дополнительный набор, не меняя основного. Или расставлять перено-
сы в тексте сразу на двух языках,  если эти языки не пересекаются по ал-
фавиту -- например, на русском и английском.


	Другие преимущества

Обработка  текста в кодировке  utf-8 и во всех однобайтовых;  отсутствие
потерь при перекодировках;  высокая производительность; отсутствие зави-
симости от установок системной локали.


========================================================================
Разъяснение работы phpHypher с различными кодировками
========================================================================

Немного  забегая  вперед,   необходимо  сделать  два  заявления.   Класс
phpHypher  корректно работает с текстом в кодировке utf-8, а также с лю-
быми однобайтными  кодовыми страницами.  Класс phpHypher  не потеряет ни
одного символа при перекодировке текста.


	Понятие базовой кодировки

Базовая кодировка -- это рабочая кодовая страница,  непосредственно  ис-
пользуемая внутри phpHypher  в процессе расстановки переносов.  Задается
в файле описания языка. С целью достижения высокой производительности, в
качестве  базовой  рабочей  кодировки   допускаются  только  однобайтные  
(в оригинальном наборе для русского языка используется  кодовая страница
CP1251).

Базовая кодировка  не имеет отношения к кодовой странице обрабатываемого
текста.


	Кодировка обрабатываемого текста

Кодовая страница обрабатываемого текста может быть utf-8 или любой одно-
байтной.  Она никак не зависит от базовой кодировки. Задается вторым па-
раметром при вызове метода hyphenate().

Высказывались опасения, что внутри phpHypher преобразование обрабатывае-
мого текста  в базовую кодировку  приведет к потере отсутствующих  в ней
символов. Спешим развеять эти опасения, ни один символ не будет потерян!

Отсутствие потерь гарантируется в силу того, что phpHypher не занимается
перекодировкой всего текста. Вместо этого, в базовую кодировку и обратно
преобразуются отдельные слова, вычлененные из текста для расстановки пе-
реносов.  Такие слова заведомо не содержат символов, несовместимых с ра-
бочей кодовой страницей.

Алгоритм вычленения  слов из текста выбирает непрерывные фрагменты,  со-
стоящие только из символов алфавита определенного языка,  и по-отдельно-
сти  направляет   их  на  расстановку   переносов   в  защищенный  метод
hyphenate_word().    Таким    образом    гарантируется,     что    метод
hyphenate_word() никогда  не получит символов,  отсутствующих  в рабочей
кодовой странице,  и всегда может безопасно,  то есть без потерь, выпол-
нить преобразование слова в базовую кодировку и обратно.


	Кодовая страница наборов правил (словарей)

Допускается любая кодировка для файлов с наборами правил,  причем каждый
словарь может иметь свою собственную.  Никаких ограничений нет.  Кодовая
страница  словаря обязательно  должна быть указана в его первой значащей
строке.


	Установки системной локали

Внутри phpHypher  не используются  зависимые от локали функции и шаблоны
регулярных  выражений,  поэтому  результат  его работы никак не связан с
установками локали.

Вычленение  слов из текста  и преобразования  регистра букв производятся
при помощи соответствующих параметров файла описания языка,  которые со-
держат все символы алфавита в верхнем и нижнем регистре.


Уникальный  дизайн phpHypher обеспечивает корректную работу даже в самых
экзотических ситуациях. Например, может использоваться CP1251 в качестве
базовой  кодировки,  два  файла  правил  в  кодовых  страницах  koi8-r и
ISO-8859-5, установлена китайская локаль, а исходный русский текст может
подаваться  в кодировке  utf-8... И даже в такой ситуации phpHypher рас-
ставит переносы и не потеряет ни одного символа из обрабатываемого  тек-
ста.


========================================================================
Описание методов и свойств класса phpHypher
========================================================================

// Constructor
__construct ( string $conffile [, int $recompile] )

Создает экземпляр объекта phpHypher и загружает информацию,  необходимую
для расстановки переносов.

$conffile 	путь и имя файла описания
$recompile 	параметр, определяющий необходимость обновления
		compiled-файла


// Properties
public $proceed_uppercase = false
public $left_limit;
public $right_limit;
public $length_limit;
public $left_limit_uc;
public $right_limit_last;

$proceed_uppercase -- свойство,  позволяющее  при необходимости расстав-
лять переносы  в словах,  содержащих  заглавные  буквы кроме первой.  По
умолчанию переносы расставляются только в словах, полностью состоящих из
строчных букв или начинающихся с заглавной буквы.

Остальные свойства класса определяют условия переноса.  Для их установки
следует использовать публичный метод set_limits(), который дополнительно
проверяет корректность условий переноса.


// Method
set_limits([, int $left_limit [, int $right_limit [,
	int $length_limit [, int $right_limit_last [,
	int $left_limit_uc]]]]] )

Устанавливает условия переноса с проверкой их корректности.

$left_limit 	    ограничение  слева --  минимальное количество симво-
		    лов,  которое можно оставлять на строке; значение по
		    умолчанию берется из файла описания языка

$right_limit	    ограничение  справа -- минимальное количество симво-
		    лов, которое можно переносить на другую строку; зна-
		    чение по умолчанию берется из файла описания языка

$length_limit	    минимальная длина слова, в котором можно расставлять
		    переносы; значение по умолчанию вычисляется как сум-
		    ма двух предыдущих параметров

$right_limit_last   минимальное количество символов, которое можно пере-
		    носить на другую строку в последнем слове абзаца; по
		    умолчанию равно ограничению справа

$left_limit_uc	    минимальное   количество  символов,   которое  можно
		    оставлять на строке в словах, начинающихся с заглав-
		    ной буквы; по умолчанию равно ограничению слева


// Method
string hyphenate(string $instr [, string $encoding [, string $shy]] )

Расставляет мягкие переносы в тексте.

возвращает	    строку с расставленными мягкими переносами

$instr		    текст для расстановки переносов

$encoding	    кодировка входного и выходного текста в виде строки,
		    распознаваемой функцией iconv; по умолчанию: базовая
		    кодировка из файла описания языка

$shy		    строка, используемая для обозначения мягкого перено-
		    са; по умолчанию: "&shy;"


========================================================================
Директивы файла описания языка
========================================================================

Директивы  подробно документированы  в самом  файле описания языка,  для
русского -- hyph_ru_RU.conf.


========================================================================
Формат файлов правил переносов phpHypher
========================================================================

Формат файлов с шаблонами phpHypher предельно прост и имеет много общего
с соответствующими файлами системы TeX.

Пустые строки и пробельные символы в начале и конце строки игнорируются.
Допускаются комментарии в стиле:

// комментарий

Если файлы шаблонов изготавливались из файлов TeX, убедитесь, что удале-
ны все элементы разметки TeX -- знаки процента,  фигурные скобки, назва-
ния секций...

В первой  значащей  строке файла шаблонов должно находиться  обозначение
его кодировки.  Она может отличаться от базовой кодировки,  может совпа-
дать с нею, но должна быть указана в любом случае.

Основу файла правил переносов составляет список шаблонов, по одному шаб-
лону в строке, аналогично секции patterns в системе TeX.

Кроме шаблонов,  в файле могут находиться словарные слова, в которых ме-
ста  возможных   переносов   обозначены   дефисами,   аналогично  секции
hyphenation в системе TeX.

Если строка не содержит ни одной цифры,  то она воспринимается  как сло-
варное слово.  При загрузке файла правил переносов словарные слова авто-
матически преобразуются в шаблоны следующим образом:

сло-во >> .с8л8о9в8о.


========================================================================
Файлы phpHypher
========================================================================

hypher.php		класс phpHypher

sk_lib_i.php		служебные функции, используемые в phpHypher

hyph_ru_RU.conf		файл описания для русского языка

hyph_ru_RU.al		базовый набор правил переносов для русского язы-
			ка, получен из свободно распространяемого набора
			правил    проф.  Александра  Ивановича  Лебедева
			ruhyphal-030310

hyph_ru_RU.addition	дополнительный набор правил,  исправляющий неко-
			торые ошибки и неточности основного набора

hyph_ru_RU.perfect	дополнительный  набор правил,  позволяющий избе-
			жать  некоторых  неблагозвучных  или  искажающих
			смысл переносов

README.ru		документация на русском языке

