<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @coder       Kalistratov Sergey <kalistratov.s.m@gmail.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

class JBCSVItemUserJBPossibleDelivery extends JBCSVItem
{

    /**
     * To CSV
     * @return string
     */
    public function toCSV()
    {
        $element = $this->_item->elements[$this->_identifier];
        foreach ($element as $key => $self) {
            $element[$key] = isset($self['value']) ? array('value' => rtrim($self['value'], '/')) : null;
        }
        return parent::toCSV();
    }

    /**
     * From CSV
     * @param $value
     * @param null $position
     * @return Item
     */
    public function fromCSV($value, $position = null)
    {
        $this->_element->bindData(array(
            'value' => trim($value)
        ));

        return $this->_item;
    }

}