<?php
/**
 * JBZoo App is universal Joomla CCK, application for YooTheme Zoo component
 *
 * @package     jbzoo
 * @version     2.x Pro
 * @author      JBZoo App http://jbzoo.com
 * @coder       Kalistratov Sergey <kalistratov.s.m@gmail.com>
 */

// no direct access
defined('_JEXEC') or die('Restricted access');

/**
 * Class ElementJBPossibleDelivery
 */
class ElementJBPossibleDelivery extends Element
{

    /**
     * Element name
     * @var string
     */
    public $elementName = 'jbpossibledelivery';

    /**
     * Element path to folder
     * @var null
     */
    private $_elementPath = null;

    /**
     * Russia month locales
     *
     * @var array
     */
    private $_locale = array();

    /**
     * Element Constructor
     */
    public function __construct()
    {
        parent::__construct();

        $this->_registerElementPath();
        $this->_initLanguage();
        $this->_locale = $this->_rusMonth();
    }

    /**
     * Checks if the element's value is set.
     * @param array $params
     * @return bool
     */
    public function hasValue($params = array())
    {
        return true;
    }

    /**
     * Get elements search data
     * @return int|null
     */
    public function getSearchData()
    {
        $value = (int)$this->get('value');

        if ($value == 0) {
            return JText::_('JBZOO_POSSIBLE_DELIVERY_SEARCH_DATA_TODAY');
        } elseif ($value == 1) {
            return JText::_('JBZOO_POSSIBLE_DELIVERY_SEARCH_DATA_TOMORROW');
        } else {
            return JText::_('JBZOO_POSSIBLE_DELIVERY_SEARCH_OTHER_DAY');
        }
    }

    /**
     * Render action
     * @param array $params
     * @return null|string|void
     */
    public function render($params = array())
    {
        $params   = $this->app->data->create($params);
        $template = $params->get('template', 'default');

        if ($template == 'default') {
            return $this->_renderTmplDefault($params);
        }

        return null;
    }

    /**
     * Edit action
     * @return mixed
     */
    public function edit()
    {
        return $this->app->html->_('control.text', $this->getControlName('value'), $this->get('value', (int)$this->config->get('quantity_days', 0)));
    }

    /**
     * Decline word
     * @param int $int
     * @param array $declines
     * @return mixed
     */
    public function decline($int = 0, $declines = array())
    {
        $int = (int)$int;

        $_declines = array(
            'one'           => JText::_('JBZOO_POSSIBLE_DELIVERY_ONE_DAY'),
            'plural'        => JText::_('JBZOO_POSSIBLE_DELIVERY_PLURAL_DAY'),
            'one_of_plural' => JText::_('JBZOO_POSSIBLE_DELIVERY_ONE_OF_PLURAL_DAY')
        );

        $declines      = array_replace($_declines, $declines);
        $declineString = $int % 10 == 1 && $int % 100 != 11 ? $declines['one'] : ($int % 10 >= 2 && $int % 10 <= 4 && ($int % 100 < 10 || $int % 100 >= 20) ? $declines['one_of_plural'] : $declines['plural']);

        return $declineString;
    }

    /**
     * Render "Default" element template
     * @param $params
     * @return string
     */
    protected function _renderTmplDefault($params)
    {
        $layout       = $this->getLayout('default.php');
        $quantityDays = (int)$params->get('quantity_days', 0);
        $dateFormat   = $params->get('date_format', 'd F Y');
        $valueDay     = $this->get('value', $quantityDays);
        $declineDays  = $this->decline($valueDay);
        $moreInfo     = htmlspecialchars_decode($params->get('more_info'));

        return self::renderLayout($layout, array(
            'quantityDays' => $quantityDays,
            'declineDays'  => $declineDays,
            'valueDay'     => $valueDay,
            'moreInfo'     => $moreInfo,
            'deliveryDate' => $this->_getDeliveryDate($valueDay, $dateFormat)
        ));
    }

    /**
     * Get delivery date
     * @param int $valueDay
     * @param string $dateFormat
     * @return string
     */
    protected function _getDeliveryDate($valueDay = 0, $dateFormat = 'Y-m-d')
    {
        $deliveryDayTime = time() + 86400 * $valueDay;

        $config   = JFactory::getConfig();
        $language = $config->get('language');

        if ($language == 'ru-RU') {
            $date = JHtml::date($deliveryDayTime, 'Y-m-d');
            $deliveryDay = $this->rusDate($dateFormat, $date);
        } else {
            $deliveryDay = JHtml::date($deliveryDayTime, $dateFormat);
        }

        return $deliveryDay;
    }

    /**
     * Register element path to folder
     * @return void
     */
    protected function _registerElementPath()
    {
        $dir = dirname(__FILE__);
        $this->app->path->register($dir, $this->elementName);
        $this->_elementPath = $this->app->path->path($this->elementName . ':');
    }

    /**
     * Init language
     * @return void
     */
    protected function _initLanguage()
    {
        $language = JFactory::getLanguage();
        $language->load('', $this->_elementPath);
    }

    /**
     * Russian date format method
     *
     * @param null $format
     * @param null $time
     * @param int $case
     * @return bool|string
     */
    public function rusDate($format = null, $time = null, $case = 1) {
        if ($time === null) {
            $time = time();
        } else {
            $time = strtotime($time);
        }

        $loc = array();
        $months = $this->_locale;

        foreach ($months as $month) {
            $cases = explode(',', $month);
            $base  = array_shift($cases);
            $cases = array_map('trim', $cases);

            $loc[] = array(
                'base'  => $base,
                'cases' => $cases
            );
        }

        $currentMonth = (int)date('n', $time) - 1;
        $F = $loc[$currentMonth]['base'] . $loc[$currentMonth]['cases'][$case];

        $format = strtr($format, array(
            'F' => $F,
            'M' => substr($F, 0, 3),
        ));

        return date($format, $time);
    }

    /**
     * Russian list month
     * @return array
     */
    private function _rusMonth()
    {
        return array(
            JText::_('JBZOO_POSSIBLE_DELIVERY_JANUARY'),
            JText::_('JBZOO_POSSIBLE_DELIVERY_FEBRUARY'),
            JText::_('JBZOO_POSSIBLE_DELIVERY_MARCH'),
            JText::_('JBZOO_POSSIBLE_DELIVERY_APRIL'),
            JText::_('JBZOO_POSSIBLE_DELIVERY_MAY'),
            JText::_('JBZOO_POSSIBLE_DELIVERY_JUNE'),
            JText::_('JBZOO_POSSIBLE_DELIVERY_JULY'),
            JText::_('JBZOO_POSSIBLE_DELIVERY_AUGUST'),
            JText::_('JBZOO_POSSIBLE_DELIVERY_SEPTEMBER'),
            JText::_('JBZOO_POSSIBLE_DELIVERY_OCTOBER'),
            JText::_('JBZOO_POSSIBLE_DELIVERY_NOVEMBER'),
            JText::_('JBZOO_POSSIBLE_DELIVERY_DECEMBER')
        );
    }

}