<?php
/**
 * @version     1.0
 * @author      Alexander Oganov
 * @date        29.03.14
 * @coder       Alexander Oganov <t_tapak@yahoo.com>
 */
defined('_JEXEC') or die('Restricted access');

App::getInstance('zoo')->loader->register('ElementRepeatable', 'elements:repeatable/repeatable.php');

class ElementImagePro extends ElementRepeatable implements iRepeatSubmittable
{

    protected $_jbimage = null;

    public function __construct()
    {
        parent::__construct();

        $this->_jbimage = $this->app->jbimage;
    }

    public function hasValue($params = array()) {
        $file = $this->get('file');
        return !empty($file) && JFile::exists(JPATH_ROOT.'/'.$this->get('file'));
    }

    public function getSearchData() {
        return $this->get('file');
    }

    public function render($params = array())
    {
        $params   = $this->app->data->create($params);
        $this->loadAssets($params);
        $layout   = $params->get('layout', 'default');
        if($layout == 'default')
            return $this->_oneImage($params);
        else
            return $this->_gallery($params);
    }

    public function _renderSubmission($params = array())
    {
        return false;
    }

    public function loadAssets()
    {
        parent::loadAssets();
        if ($this->config->get('fancybox', 1)) {
            $this->app->document->addStyleSheet('elements:imagepro/assets/css/fancybox.css');
            $this->app->document->addScript('elements:imagepro/assets/js/lightbox-fancybox.js');
        }
        $this->app->document->addScript('elements:imagepro/assets/js/etalage.js');
        $this->app->document->addStyleSheet('elements:imagepro/assets/css/gallery.css');
        return $this;
    }

    public function getConfigForm() {
        return parent::getConfigForm()->addElementPath(dirname(__FILE__));
    }

    protected function _edit($params = array()) {
        $this->app->document->addScript('elements:imagepro/assets/js/image.js');

        if ($layout = $this->getLayout('edit.php')) {
            return $this->renderLayout($layout);
        }
        return null;
    }

    protected function _oneImage($params = array())
    {
        $link     = null;
        $layout   = $this->getLayout('default.php');
        $width    = $params->get('width');
        $height   = $params->get('height');
        $image    = $this->_jbimage->resize($this->get('file'), $width, $height);

        $ref      = $params->get('link_to_item', 0);
        if($ref == 1)
            $link   = $this->app->route->item($this->_item);
        return self::renderLayout($layout, array(
                'url'      => $image->url,
                'width'    => $image->width,
                'height'   => $image->height,
                'original' => $this->get('file'),
                'title'    => $this->get('title') ? $this->get('title') : $this->_item->name,
                'link'     => $link,
                'ref'      => $ref
            )
        );
    }

    protected function _gallery($params)
    {
        $layout       = $this->getLayout('gallery.php');

        $data             = $this->data();
        $zoom             = $params->get('zoom', 1);
        $lightbox         = $params->get('lightbox', 1);
        $width            = $params->get('width', 400);
        $height           = $params->get('height', 300);
        $zoom_width       = $params->get('zoom_width', 300);
        $zoom_height      = $params->get('zoom_height', 300);
        $autoplay         = $params->get('autoplay', 0);
        $change           = $params->get('change', 0);
        $interval         = $params->get('interval', 6000);
        $buttons          = $params->get('buttons', 0);
        $images           = $params->get('limit', 3);
        $scroll           = $params->get('scroll', false);
        $show_title       = $params->get('show_title', 0);
        $thumb_pos        = $params->get('thumb_pos', 'bottom');
        $zoom_img_width   = $params->get('zoom_img_width', 750);
        $zoom_img_height  = $params->get('zoom_img_height', 750);

        foreach($data as $k => $v) {
            $gallery[$k]['img']          = $this->_jbimage->resize($v['file'], $width, $height)->url;
            $gallery[$k]['original']     = $v['file'];
            $gallery[$k]['title']        = $v['title'] ? $v['title'] : $this->_item->name;
        }

        return self::renderLayout($layout, array(
                'gallery'          => $gallery,
                'zoom'             => $zoom,
                'lightbox'         => $lightbox,
                'images'           => $images,
                'autoplay'         => $autoplay,
                'interval'         => $interval,
                'change'           => $change,
                'scroll'           => $scroll,
                'buttons'          => $buttons,
                'zoom_width'       => $zoom_width,
                'zoom_height'      => $zoom_height,
                'width'            => $width,
                'height'           => $height,
                'show_title'       => $show_title,
                'position'         => $thumb_pos,
                'zoom_img_width'   => $zoom_img_width,
                'zoom_img_height'  => $zoom_img_height
            )
        );
    }

}