<?php
defined('_JEXEC') or die('Restricted access');

App::getInstance('zoo')->loader->register('ElementRepeatable', 'elements:repeatable/repeatable.php');

class ElementImagePro extends ElementRepeatable implements iRepeatSubmittable
{

    protected $_jbimage = null;

    /**
     * Class constructor
     */
    public function __construct()
    {
        parent::__construct();

        $this->_jbimage = $this->app->jbimage;
    }

    public function hasValue($params = array()) {
        $file = $this->get('file');
        return !empty($file) && JFile::exists(JPATH_ROOT.'/'.$this->get('file'));
    }

    public function getSearchData() {
        return $this->get('file');
    }

    public function render($params = array())
    {
        $params   = $this->app->data->create($params);
        $this->loadAssets($params);
        $layout   = $params->get('layout', 'default');
        if($layout == 'default')
            return $this->_oneImage($params);
        else
            return $this->_gallery($params);
    }

    public function _renderSubmission($params = array())
    {
        return false;
    }

    public function loadAssets()
    {
        parent::loadAssets();
        $this->app->document->addStyleSheet('elements:imagepro/assets/css/gallery.css');
        $this->app->document->addStyleSheet('elements:imagepro/assets/css/fancybox.css');
        $this->app->document->addScript('elements:imagepro/assets/js/lightbox-fancybox.js');
        $this->app->document->addScript('elements:imagepro/assets/js/zoom.js');
        $this->app->document->addScript('elements:imagepro/assets/js/owl.js');
        return $this;
    }

    public function getConfigForm() {
        return parent::getConfigForm()->addElementPath(dirname(__FILE__));
    }

    protected function _edit($params = array()) {
        $this->app->document->addScript('elements:imagepro/assets/js/image.js');

        if ($layout = $this->getLayout('edit.php')) {
            return $this->renderLayout($layout);
        }

        return null;
    }

    protected function _oneImage($params = array())
    {
        $link     = null;
        $layout   = $this->getLayout('default.php');
        $width    = $params->get('width');
        $height   = $params->get('height');
        $image    = $this->_jbimage->resize($this->get('file'), $width, $height);

        $ref      = $params->get('link_to_item', 0);
        if($ref == 1)
            $link   = $this->app->route->item($this->_item);
        return self::renderLayout($layout, array(
                'url'      => $image->url,
                'width'    => $image->width,
                'height'   => $image->height,
                'original' => $this->get('file'),
                'title'    => $this->get('title') ? $this->get('title') : $this->_item->name,
                'link'     => $link,
                'ref'      => $ref
            )
        );
    }

    protected function _gallery($params)
    {
        $layout = $this->getLayout('gallery.php');
        $data         = $this->data();
        $width        = $params->get('width', 400);
        $height       = $params->get('height', 300);
        $small_width  = $params->get('small_width', 100);
        $small_height = $params->get('small_height', 100);
        $zoom         = $params->get('zoom_type', 'inner');
        $limit        = $params->get('limit', 0);
        $autoplay     = $params->get('autoplay', 0);
        $scroll       = $params->get('scroll', false);

        foreach($data as $k => $v) {
            $gallery[$k]['img']          = $this->_jbimage->resize($v['file'], $width, $height)->url;
            $gallery[$k]['original']     = $v['file'];
            $gallery[$k]['width']        = $width;
            $gallery[$k]['height']       = $height;
            $gallery[$k]['small_img']    = $this->_jbimage->resize($v['file'], $small_width, $small_height)->url;
            $gallery[$k]['small_width']  = $small_width;
            $gallery[$k]['small_height'] = $small_height;
        }
        return self::renderLayout($layout, array(
            'gallery'    => $gallery,
            'zoom'       => $zoom,
            'limit'      => $limit,
            'autoplay'   => $autoplay,
            'scroll'     => $scroll
            )
        );
    }

}