<?php
/**************************
* @package    ZOO Component
* @file       splitter.php
* @version    3.1.0 September 2013
* @author     Attavus M.D. http://www.raslab.org
* @copyright  Copyright (C) R.A.S.Lab[.org]
* @license    http://opensource.org/licenses/GPL-2.0 GNU/GPLv2 only
******************************************************************/

// no direct access
defined('_JEXEC') or die('Restricted access');

/*
	Class: ElementSplitter
		The splitter element class
*/
class ElementSplitter extends Element implements iSubmittable {

	/*
		Function: hasValue
			Checks if the element's value is set.

	    Parameters:
			$params - render parameter

		Returns:
			Boolean - true, on success
	*/
	public function hasValue($params = array()) {

		return true;
	}

	/*
	   Function: edit
	       Renders the edit form field.

	   Returns:
	       String - html
	*/
	public function edit() {
		return null;
	}

	/*
		Function: render
			Renders the element.

	   Parameters:
            $params - render parameter

		Returns:
			String - html
	*/
	public function render($params = array()) {
		// init vars
		$params = $this->app->data->create($params);
		// output
		return $this->_applySeparators($params);
	}

	/*
		Function: renderSubmission
			Renders the element in submission.

	   Parameters:
			$params - AppData submission parameters

		Returns:
			String - html
	*/
	public function renderSubmission($params = array()) {
		// init vars
		$params = $this->app->data->create($params);
		// output
		return $this->_applySeparators($params);
	}
	
	/*
		Function: validateSubmission
			Validates the submitted element

	   Parameters:
			$value  - AppData value
			$params - AppData submission parameters

		Returns:
			Array - cleaned value
	*/
	public function validateSubmission($value, $params){
		return array();
	}

	private function _applySeparators($params) {
		return $this->app->element->applySeparators($params->get('separator'), array('<span style="clear: '.$params->get('clearfix', 'none').';">','</span>'));
	}
}
